#!/usr/local/bin/perl
# $Header: opsm/utl/oc4jctl.pl /main/5 2012/02/27 14:50:32 jgrout Exp $
#
# oc4jctl.pl
# 
# Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oc4jctl.pl - Generic OC4J Control Action Script
#
#    DESCRIPTION
#     This generic action script handles OC4J control operations
#
#    MODIFIED   (MM/DD/YY)
#    jgrout      02/07/12 - Rewrite from scratch as generic action script
#    sbasu       06/09/10 - modify order of arguments
#    sbasu       11/09/09 - #9050620 - handle OFFLINE/FAILED state for OC4J res
#    sbasu       03/01/09 - #8228103:check DBWLM servlet
#    msubrahm    02/09/09 - Use http port
#    sbasu       01/12/09 - pass http port as an argument
#    lweng       10/26/07 - Creation
# 
use strict;
use oc4jctl_common;
use oc4jctl_lib;

sub dispatch_actions
#---------------------------------------------------------------------
# Function: Dispatch actions
#
# Args    : The action to be performed ("start", "stop", "check", "clean")
#           Optional second argument (for "clean", time to wait after SIGQUIT)
#
# Returns : Agent status code (see oc4jctl_common package)
#---------------------------------------------------------------------
{
  # The first argument is the action to be performed
  my ($action, $timeout) = @_;
  my $rc;

  debug_out("... BEGIN_DEBUG [Action= $action] ...");

  if ($action eq "check")
  {
    $rc = oc4j_check();
    debug_out(" ... CHECK - Return Code = $rc ...");
  }
  elsif ($action eq "start")
  {
    $rc = oc4j_start();
    debug_out("... START - Return code = $rc ...");
  }
  elsif ($action eq "stop")
  {
    $rc = oc4j_stop();
    debug_out("... STOP - Return code = $rc ...");
  }
  elsif ($action eq "clean")
  {
    $rc = oc4j_clean($timeout);
    debug_out("... CLEAN - Return code = $rc ...");
  }
  else
  {
    $rc = STATE_ONLINE;
    debug_out("... UNKNOWN ACTION IGNORED ...");
  }
  debug_out(" ... END_DEBUG [Action=$action] ...");

  return $rc;
}

#---------------------------------------------------------------------
# Function: Main program
#
# Args    : The action to be performed ("start", "stop", "check", "clean")
#           Optional second argument (for "clean", time to wait after SIGQUIT)
#
# Returns : Agent status code (see oc4jctl_common package)
#---------------------------------------------------------------------

# Initialize globals

my $rc = init_globals();

if ($rc == FAIL_CODE)
{
  # If initialization fails, exit with STATE_UNKNOWN
  $rc = STATE_UNKNOWN;
}
else
{
  if (@ARGV < 2)
  {
    $rc = dispatch_actions($ARGV[0], "null");
  }
  else
  {
    $rc = dispatch_actions($ARGV[0], $ARGV[1]);
  }
}

exit $rc;
